/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.block;

import com.sihenzhang.crockpot.block.entity.CrockPotBlockEntities;
import com.sihenzhang.crockpot.block.entity.CrockPotBlockEntity;
import com.sihenzhang.crockpot.item.CrockPotItems;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.network.NetworkHooks;

public class CrockPotBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    private final int potLevel;

    public CrockPotBlock(int potLevel) {
        super(BlockBehaviour.Properties.m_284310_().m_60999_().m_60913_(1.5f, 6.0f).m_60953_(state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? 13 : 0).m_60955_());
        this.potLevel = potLevel;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    public int getPotLevel() {
        return this.potLevel;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity;
        if (!pLevel.f_46443_ && (blockEntity = pLevel.m_7702_(pPos)) instanceof CrockPotBlockEntity) {
            CrockPotBlockEntity crockPotBlockEntity = (CrockPotBlockEntity)blockEntity;
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)crockPotBlockEntity, (BlockPos)pPos);
        }
        return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        BlockEntity blockEntity;
        if (!pState.m_60713_(pNewState.m_60734_()) && (blockEntity = pLevel.m_7702_(pPos)) instanceof CrockPotBlockEntity) {
            CrockPotBlockEntity crockPotBlockEntity = (CrockPotBlockEntity)blockEntity;
            Containers.m_19002_((Level)pLevel, (BlockPos)pPos, (Container)new RecipeWrapper((IItemHandlerModifiable)crockPotBlockEntity.getItemHandler()));
            if (crockPotBlockEntity.isCooking()) {
                Containers.m_19002_((Level)pLevel, (BlockPos)pPos, (Container)new SimpleContainer(new ItemStack[]{((Item)CrockPotItems.WET_GOOP.get()).m_7968_()}));
            }
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof CrockPotBlockEntity) {
            CrockPotBlockEntity crockPotBlockEntity = (CrockPotBlockEntity)blockEntity;
            crockPotBlockEntity.recheckOpen();
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_());
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (((Boolean)pState.m_61143_((Property)LIT)).booleanValue()) {
            double xPos = (double)pPos.m_123341_() + 0.5;
            double yPos = (double)pPos.m_123342_() + 0.2;
            double zPos = (double)pPos.m_123343_() + 0.5;
            if (pRandom.m_188503_(10) == 0) {
                pLevel.m_7785_(xPos, yPos, zPos, SoundEvents.f_11784_, SoundSource.BLOCKS, pRandom.m_188501_() + 0.5f, Mth.m_216267_((RandomSource)pRandom, (float)0.6f, (float)1.3f), false);
            }
            double xOffset = Mth.m_216263_((RandomSource)pRandom, (double)-0.15, (double)0.15);
            double zOffset = Mth.m_216263_((RandomSource)pRandom, (double)-0.15, (double)0.15);
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123762_, xPos + xOffset, yPos, zPos + zOffset, 0.0, 0.0, 0.0);
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123744_, xPos + xOffset, yPos, zPos + zOffset, 0.0, 0.0, 0.0);
        }
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, LIT, OPEN});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new CrockPotBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.f_46443_ ? null : CrockPotBlock.m_152132_(pBlockEntityType, (BlockEntityType)((BlockEntityType)CrockPotBlockEntities.CROCK_POT_BLOCK_ENTITY.get()), CrockPotBlockEntity::serverTick);
    }
}

